<?php
require_once(APP_ROOT . DS . 'mail' . DS . 'mailhandle.php');

function dnd($data)
{
    echo ('<pre>');
    var_dump($data);
    echo ('</pre>');
    die();
}

function sanitize($input)
{
    global $conn;
    $input = htmlspecialchars(strip_tags(trim($input)));
    $input = mysqli_real_escape_string($conn, $input);
    return $input;
}

function redirect($url)
{
    header('Location: ' . ROOT . $url);

    die();
}

function alert($icon, $title, $text)
{
    $alart = "<script>
    Swal.fire({
        icon: '$icon',
        title: '$title',
        text: '$text!',
       
    });
    </script>";
    return $alart;
}

// register funtions

function emptyField($inputs)
{
    foreach ($inputs as $k => $v) {
        if (empty($v)) {
            $error = "$k field is empty";
            return $error;
        }
    }
}

function password_match($pass1, $pass2)
{
    if ($pass1 == $pass2) {
        return true;
    }
    return false;
}

function validEmail($email)
{
    $mail = trim($email);
    if (filter_var($mail, FILTER_VALIDATE_EMAIL)) return true;
    return false;
}

function query($sql, $params, $db)
{

    // create an SQL query with placeholders and prepare it
    $in    = str_repeat('?,', count($params) - 1) . '?'; //  returns ?,?,?...
    //  $sql = "SELECT * FROM users WHERE username = ? OR email = ?"; 
    $stmt  = $db->prepare($sql);

    // create the types string dynamically and bind an array
    $types = str_repeat('s', count($params)); // returns sss...
    $stmt->bind_param($types, ...$params);

    return $stmt;
}

function passwordHash($password)
{

    $hashed =  password_hash($password, PASSWORD_DEFAULT);
    return $hashed;
}

function validUser($name1, $name2, $mail, $db)
{
    $sql = "SELECT * FROM accounts WHERE first_name = '$name1' AND last_name = '$name2' OR email='$mail'";
    $result = $db->query($sql);
    if ($result->num_rows > 0) {
        $data = $result->fetch_assoc();

        $db = null;

        return $data;
    }
   
}

function acc_exit($acc, $db)
{
    $sql = "SELECT * FROM accounts WHERE account_number = '$acc'";
    $result = $db->query($sql);

    if ($result->fetch_assoc()) {
        $db = null;
        return true;
    } else {
        $db = null;
        return false;
    }
}

function pan_exit($pan, $db)
{
    $sql = "SELECT * FROM accounts WHERE pan = '$pan'";
    $result = $db->query($sql);

    if ($result->fetch_assoc()) {
        $db = null;
        return true;
    } else {
        $db = null;
        return false;
    }
}

function addUserToDatabase($params, $db)
{

    $stmt =  query("INSERT INTO accounts(first_name,last_name,email,phone,gender,country,state,address,postcode,account_type,currency,password,passport) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)", $params, $db);

    // execute and fetch the rows
    if ($stmt->execute()) {
        $db = null;
        return true;
    } else {
        $db = null;
        return false;
    }
}

// login funtions

function verify_account($acc_num, $pass, $db)
{
    $sql = "SELECT * FROM accounts WHERE account_number = '$acc_num' OR email = '$acc_num'";
    $result = $db->query($sql);
    $data = $result->fetch_assoc();
    if (!empty($data)) {

        extract($data);
        $db = null;

        if ($status != 'active') {
            return "Sorry! This account has been suspended";
        }

        if (password_verify($pass, $password)) {
            return $data;
        } else {
            return "Incorrect login details";
        }
    } else {
        return "Account does not exist, please check account number";
    }
}

function user_account($user, $db)
{
    $sql = "SELECT * FROM accounts WHERE account_number = '$user'";
    $result = $db->query($sql);
    $data = $result->fetch_assoc();
    extract($data);
    $db = null;

    if ($status != 'active') {
        $error = 'This account has been SUSPENDED, please contact customer support';
        $_SESSION['msg'] = alert($icon = 'error', $title = 'Oops...', $text = $error);
        redirect('userarea.php');
    } else {
        return $data;
    }
}

// funtions for uploading/updating images

function img_saver($img, $img_name)
{
    $f_name = $img['name'];
    $f_type = $img['type'];
    $f_tmp = $img['tmp_name'];
    $f_error = $img['error'];
    $f_size = $img['size'];

    if (empty($f_name)) {
        $error = $img_name . " field is empty";
        $_SESSION['msg'] = alert($icon = 'error', $title = 'Oops...', $text = $error);
        redirect('userarea.php');
    }

    $terget_f = APP_ROOT . DS . 'uploads' . DS;
    $new_fname = uniqid('', true);

    $file_extention = explode('.', $f_name);
    $file_extention = strtolower(end($file_extention));

    $white_list = ['jpg', 'jpeg', 'png'];
    $fname = $new_fname . '.' . $file_extention;
    $locate =  $terget_f . $fname;

    if (in_array($file_extention, $white_list)) {
        if (!$f_error) {
            $move_f = move_uploaded_file($f_tmp, $locate);

            if ($move_f) {
                $locate = ROOT . 'uploads/' . $fname;

                return $locate;
            }
        }
    } else {
        $error = $img_name . " file type is not an image";
        $_SESSION['msg'] = alert($icon = 'error', $title = 'Oops...', $text = $error);
        redirect('userarea.php');
    }
}

function verify_transaction($acc, $code, $t_amount, $db)
{
    $sql = "SELECT * FROM accounts WHERE account_number = '$acc'";
    $result = $db->query($sql);
    $data = $result->fetch_assoc();
    extract($data);
    if ($pan != $code) {
        return 'P.A.N is Incorrect please Try Again';
    } elseif ($t_amount >= $balance) {
        return 'Insufficient Balance For Transaction';
    }
    return false;
}

function debit($send_acc, $rsv_acc, $rsv_name, $amt, $bank, $db)
{
    $sql = "SELECT * FROM accounts WHERE account_number = '$send_acc'";
    $result = $db->query($sql);
    $data = $result->fetch_assoc();
    extract($data); 
    $transaction = $balance - $amt;
   

    $sql = "UPDATE accounts SET balance = '$transaction' WHERE account_number = '$send_acc'";
    $result = $db->query($sql);

    $name = $first_name . ' ' . $last_name;
    $t_date = date('D d M Y');
    $t_balance = $transaction;
    $amt = $amt;

    $t_detail = 'TO | '. $rsv_name. ' | E-CHANNELS | '. $bank;

    debit_mail($email, $send_acc, $amt, $t_balance, $name, $t_date, $currency,$t_detail);

    $sql = "INSERT INTO statement (acc_no, detail, type, amount, balance, date,status,receiver)
    VALUES ('$account_number', '$t_detail','debit','$amt','$t_balance','$t_date','pending','$rsv_acc')";
    $db->query($sql);

    return $name;
}

function credit($email, $sender_acc, $receiver_acc, $name,$transfer_amount, $detail, $db){
   
    $sql = "SELECT * FROM accounts WHERE account_number = '$receiver_acc'";
    $result = $db->query($sql);
    $data = $result->fetch_assoc();
    extract($data);

    $transaction = $balance + $transfer_amount;

    $sql = "UPDATE accounts SET balance = '$transaction' WHERE account_number = '$receiver_acc'";
    $result = $db->query($sql);

    $t_date = date('D d M Y');
    $t_balance = $transaction;
    $amt = $transfer_amount;

    $sql = "SELECT first_name,last_name FROM accounts WHERE account_number = '$sender_acc'";
    $result = $db->query($sql);
    $data = $result->fetch_assoc();
    extract($data);

    $sender_name = $first_name.' '.$last_name;

    $detail = "FROM | ".$sender_name." | E-CHANNELS | CREDENCE FUNDS";

    credit_mail($email, $amt, $t_balance, $name, $t_date, $currency,$detail,$account_number);

    $sql = "INSERT INTO statement (acc_no, detail, type, amount, balance, date)
    VALUES ('$receiver_acc', '$detail','Credit','$amt','$t_balance','$t_date')";
    $db->query($sql);

    return true;

}

function img_update($img, $img_name, $img_locate,$user)
{
    $f_name = $img['name'];
    $f_type = $img['type'];
    $f_tmp = $img['tmp_name'];
    $f_error = $img['error'];
    $f_size = $img['size'];

    if (empty($f_name)) {
        return $img_locate;
    }

    $terget_f = APP_ROOT . DS . 'uploads' . DS;
    $new_fname = uniqid('', true);

    $file_extention = explode('.', $f_name);
    $file_extention = strtolower(end($file_extention));

    $white_list = ['jpg', 'jpeg', 'png'];
    $fname = $new_fname . '.' . $file_extention;
    $locate =  $terget_f . $fname;
  
    if (in_array($file_extention, $white_list)) {
        if (!$f_error) {
            $move_f = move_uploaded_file($f_tmp, $locate);

            if ($move_f) {
                $locate = ROOT . 'uploads/' . $fname;
             
                return $locate;
            }
        }
    } else {
        $error = $img_name . " file type is not an image";
        $_SESSION['msg'] = alert($icon = 'error', $title = 'Oops...', $text = $error);
        redirect("admin/view.php?user=$user");
    }
}

// funtions for handling adding properties to database
function add_property_to_Database($params, $db)
{

    $stmt =  query("INSERT INTO properties(p_id,name,address,country,city,state,type,status,bedroom,bathroom,size,price,running,net_return,description,image1,image2,image3,image4,image5) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", $params, $db);

    // execute and fetch the rows
    if ($stmt->execute()) {
        $db = null;
        return true;
    } else {
        $db = null;
        return false;
    }
}
