<?php
require_once('../app.php');

if (isset($_SESSION['user'])) {

    $user_acc = $_SESSION['user'];
    extract($user_acc);

    $user_acc = user_account($account_number, $conn);
    extract($user_acc, EXTR_OVERWRITE);

    $balance = number_format($balance, 2);
    if ($balance == '0') {
        $balance = '0.00';
    }

    require_once(APP_ROOT . DS . 'app' . DS . 'includes' . DS . 'top.php');
?>

    <body class="g-sidenav-show  bg-gray-200">

        <?php require_once(APP_ROOT . DS . 'app' . DS . 'includes' . DS . 'barnav.php'); ?>
        <!-- End Navbar -->
        <div class="container-fluid py-4">




            <div class="row">
                <div class="col-lg-12 mb-4">
                    <div class="row">
                        <div class="col-xl-6 mb-xl-0 mb-4">
                            <div class="card bg-transparent shadow-xl">
                                <div class="overflow-hidden position-relative border-radius-xl">
                                    <img src="<?= ROOT ?>assets/img/illustrations/pattern-tree.svg" class="position-absolute opacity-2 start-0 top-0 w-100 z-index-1 h-100" alt="pattern-tree">
                                    <span class="mask bg-gradient-dark opacity-10"></span>
                                    
                                    <div class="card-body position-relative w-100 z-index-1 d-flex justify-content-between">
                                    <div class="d-flex flex-column justify-content-between">
                                        <div style="margin-bottom: 1.5rem;">
                                            <span class="badge rounded-pill bg-success"><?= $status ?> Acc. 1 of
                                                1</span>
                                                <h6 class="text-white mb-0 text-capitalize "><?= $first_name ?>
                                                <?= $last_name ?>
                                            </h6>
                                        </div>

                                        <div class="">
                                          
                                            <p class="text-white mt-1 mb-1 pb-0">
                                                <?= $account_number ?>
                                            </p>

                                            <span class=" mt-0 pt-0"><?= $account_type ?> Account</span>
                                        </div>
                                    </div>

                                    <div class=" d-flex align-items-end justify-content-center flex-column">

                                        <img class="w-60 mt-2 rounded" src="<?= $passport ?>" alt="logo"
                                            style="width: 100%; height: inherit600px">
                                    </div>

                                </div>

                                </div>
                            </div>
                        </div>

                        <div class="col-xl-6 mt-5">
                            <div class="row">
                                <div class="col-md-6  col-12 mb-3">
                                    <div class="card">
                                        <div class="card-header mx-4 p-3 text-center">
                                            <div class="icon icon-shape icon-lg bg-gradient-primary shadow text-center border-radius-lg">
                                                <i class="icofont-bank opacity-10"></i>
                                            </div>
                                        </div>
                                        <div class="card-body pt-0 p-3 text-center">
                                            <h6 class="text-center mb-0">Account Balance</h6>
                                            <span class="text-xs"></span>
                                            <hr class="horizontal dark my-3">
                                            <h5 class="mb-0 text-info">$<?= $balance ?></h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6  col-12 mb-3">
                                    <div class="card">
                                        <div class="card-header mx-4 p-3 text-center">
                                            <div class="icon icon-shape icon-lg bg-gradient-primary shadow text-center border-radius-lg">
                                                <i class="icofont-coins opacity-10"></i>
                                            </div>
                                        </div>
                                        <div class="card-body pt-0 p-3 text-center">
                                            <h6 class="text-center mb-0">Book Balance</h6>
                                            <span class="text-xs"></span>
                                            <hr class="horizontal dark my-3">
                                            <h5 class="mb-0 text-info">$<?= $balance ?></h5>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>





                <!-- <div class="col-lg-4">
                    <div class="card h-100">
                        <div class="card-header pb-0 p-3">
                            <div class="row">
                                <div class="col-6 d-flex align-items-center">
                                    <h6 class="mb-0">Invoices</h6>
                                </div>
                                <div class="col-6 text-end">
                                    <button class="btn btn-outline-primary btn-sm mb-0">View All</button>
                                </div>
                            </div>
                        </div>
                        <div class="card-body p-3 pb-0">
                            <ul class="list-group">
                                <li class="list-group-item border-0 d-flex justify-content-between ps-0 mb-2 border-radius-lg">
                                    <div class="d-flex flex-column">
                                        <h6 class="mb-1 text-dark font-weight-bold text-sm">March, 01, 2020</h6>
                                        <span class="text-xs">#MS-415646</span>
                                    </div>
                                    <div class="d-flex align-items-center text-sm">
                                        $180
                                        <button class="btn btn-link text-dark text-sm mb-0 px-0 ms-4"><i class="material-icons text-lg position-relative me-1">picture_as_pdf</i> PDF</button>
                                    </div>
                                </li>
                                <li class="list-group-item border-0 d-flex justify-content-between ps-0 mb-2 border-radius-lg">
                                    <div class="d-flex flex-column">
                                        <h6 class="text-dark mb-1 font-weight-bold text-sm">February, 10, 2021</h6>
                                        <span class="text-xs">#RV-126749</span>
                                    </div>
                                    <div class="d-flex align-items-center text-sm">
                                        $250
                                        <button class="btn btn-link text-dark text-sm mb-0 px-0 ms-4"><i class="material-icons text-lg position-relative me-1">picture_as_pdf</i> PDF</button>
                                    </div>
                                </li>
                                <li class="list-group-item border-0 d-flex justify-content-between ps-0 mb-2 border-radius-lg">
                                    <div class="d-flex flex-column">
                                        <h6 class="text-dark mb-1 font-weight-bold text-sm">April, 05, 2020</h6>
                                        <span class="text-xs">#FB-212562</span>
                                    </div>
                                    <div class="d-flex align-items-center text-sm">
                                        $560
                                        <button class="btn btn-link text-dark text-sm mb-0 px-0 ms-4"><i class="material-icons text-lg position-relative me-1">picture_as_pdf</i> PDF</button>
                                    </div>
                                </li>
                                <li class="list-group-item border-0 d-flex justify-content-between ps-0 mb-2 border-radius-lg">
                                    <div class="d-flex flex-column">
                                        <h6 class="text-dark mb-1 font-weight-bold text-sm">June, 25, 2019</h6>
                                        <span class="text-xs">#QW-103578</span>
                                    </div>
                                    <div class="d-flex align-items-center text-sm">
                                        $120
                                        <button class="btn btn-link text-dark text-sm mb-0 px-0 ms-4"><i class="material-icons text-lg position-relative me-1">picture_as_pdf</i> PDF</button>
                                    </div>
                                </li>
                                <li class="list-group-item border-0 d-flex justify-content-between ps-0 border-radius-lg">
                                    <div class="d-flex flex-column">
                                        <h6 class="text-dark mb-1 font-weight-bold text-sm">March, 01, 2019</h6>
                                        <span class="text-xs">#AR-803481</span>
                                    </div>
                                    <div class="d-flex align-items-center text-sm">
                                        $300
                                        <button class="btn btn-link text-dark text-sm mb-0 px-0 ms-4"><i class="material-icons text-lg position-relative me-1">picture_as_pdf</i> PDF</button>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div> -->
            </div>

            <div class="row">
                <div class="col-12">
                    <div class="card my-4">
                        <div class="card-header p-0 position-relative mt-n4 mx-3 z-index-2">
                            <div class="bg-gradient-primary shadow-primary border-radius-lg pt-4 pb-3">
                                <h6 class="text-white text-capitalize ps-3">Recent Transactions</h6>
                            </div>
                        </div>
                        <div class="card-body px-0 pb-2">
                            <div class="table-responsive p-0">
                                <table class="table align-items-center mb-0">
                                    <thead>
                                        <tr>
                                            <th class="text-uppercase text-center text-secondary opacity-7">DATE</th>
                                            <th class="text-center text-uppercase text-secondary opacity-7">DETAIL</th>
                                            <th class="text-center text-uppercase text-secondary opacity-7">TRANSACTION TYPE
                                            </th>
                                            <th class="text-secondary text-center text-uppercase opacity-7">AMOUNT</th>
                                            <th class="text-secondary text-center text-uppercase opacity-7">BALANCE</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php
                                        $sql = "SELECT * FROM statement WHERE acc_no = '$account_number' ORDER BY id DESC LIMIT 20";
                                        $result = $conn->query($sql);
                                        while ($row = $result->fetch_assoc()) {
                                            extract($row);
                                        ?>

                                            <tr>
                                                <td class="text-center text-sm"><?= $date ?></td>
                                                <td class="text-center text-sm"><?= $detail ?></td>
                                                <td class="<?= $type ?> text-center text-sm"><?= $type ?></td>
                                                <td class="<?= $type ?> text-center text-sm">$<?= number_format($amount, 2) ?>
                                                </td>
                                                <td class="color-primary text-center text-sm""><?= $currency ?><?= number_format($balance, 2) ?></td>
                                            </tr>

                                        <?php
                                        }
                                        $conn->close();
                                        ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <footer class=" footer py-4 ">
                <div class=" container-fluid">
                                                    <div class="row align-items-center justify-content-lg-between">
                                                        <div class="col-lg-6 mb-lg-0 mb-4">
                                                            <div class="copyright text-center text-sm text-muted text-lg-start">
                                                                ©
                                                                <script data-cfasync="false" src="<?= ROOT ?>cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js">
                                                                </script>
                                                                <script>
                                                                    document.write(new Date().getFullYear())
                                                                </script>, <?= SITE_NAME ?> Finance All Rights Reserved.
                                                            </div>
                                                        </div>

                                                    </div>
                            </div>
                            </footer>





                            <?php require_once(APP_ROOT . DS . 'app' . DS . 'includes' . DS . 'bottom.php'); ?>

                            <?php
                            require_once(APP_ROOT . DS . 'app' . DS . 'includes' . DS . 'jslinks.php');
                            if (isset($_SESSION['msg'])) {
                                echo ($_SESSION['msg']);
                                $_SESSION['msg'] = '';
                            }
                            ?>

    </body>


    </html>

<?php
} else {
    redirect('userarea');
}
?>